clc,clear,
close all

%% Tirando le somme dei test sul platooning
Lmemo=[]; Cmemo=[];
 DsuL = [0.25 0.5 0.75 1 1.5 2 3];
%DsuL = [3 4 5 6 7 9.27];
%DsuL = [3 3.50 4.15];
wind = [500 600 700 800 900];
%%
LibO = myOutputFile;

disp('Files Analizzati')

motherFolder = "results fullPlat";
%double: un furgone avanti e uno dietro,
%back: il furgone fantoccio è dietro,
%front: il furgone fantoccio è davanti.

filtro     = "front";
antifiltro = "open jet";


elenco=strings(1,0);
elencoFiles = dir( [pwd filesep] + motherFolder+ '/Loa');
for i=1:length(elencoFiles)
    eFn = elencoFiles(i).name;
    if contains(eFn,"TEST") && contains(eFn,filtro) && ~contains(eFn,antifiltro)
        elenco = cat(2,elenco,string([elencoFiles(i).folder filesep elencoFiles(i).name]));
        disp( elencoFiles(i).name)
    end
end
%%
figure
for fileN=elenco
    
    temporaneo = LibO.txt2struct(char(fileN),motherFolder);
    [D,t,~]=LibO.extractFromFile(temporaneo.loa);
    tag = strsplit(temporaneo.loa,filesep);
    a=plot(t,D(:,1),'-','LineW',0.25,'DisplayName',...
        regexprep(tag{end},'5winds.*',''),'tag','real'); hold on
    
    [tgood, Lgood, Cgood] = deal(cell(1,5));
    
    passo = round(t(end))/length(wind);
    interv=0:passo:passo*length(wind)-1;
    discard=10; %<- la finestra (in secondi) di segnale da ignorare tra un blocco e il successivo
    
    for i=1:length(interv)
        intgood = [interv(i)+discard interv(i)+passo-discard];
        tgood{i} = intgood;
        Lgood{i} = D(t>=intgood(1) & t<=intgood(2),1);
        Cgood{i} = D(t>=intgood(1) & t<=intgood(2),4);
        plot(intgood,mean(Lgood{i})*[1 1],'--','LineW',2,'Color',a.Color);
    end
    Lmemo(end+1,:) = cellfun(@mean,Lgood);
    Cmemo(end+1,:) = cellfun(@mean,Cgood);
end

%%
set(gcf,'Color','w');
ll=legend(findobj(gca,'Tag','real')); ll.ItemHitFcn=@myTdmsReader.ShowOnOff;
xticks(0:passo:t(end));
fermo = ylim;
xlabel('Time [s]');  xlim([0 t(end)])
ylabel('Load Cell [V]');
title({'Test Platooning per 5 velocità del vento'; char(strjoin('['+string(wind)'+" giri]",',       '))})
%%
xticks(cat(2,tgood{:}));
ylim(fermo)
%% Variazione percentuale di E su E0
E0 = Lmemo(1,:);
E = Lmemo(2:end,:);

% pathZero = 'C:\Users\nitro\Desktop\old tesi\I Miei Progressi\results Daq\Loa\zero60 _Loa (Nov 15 12_26).txt';
% zeroV = LibO.extractFromFile(pathZero);
% zeroV = mean(Zero(:,[1 4]));  %--> [2.872748438	-10.39129517 -0.001207838	-0.088105225]
zeroV = [2.872748438 -0.088105225];

[WindTab,CDTab,DragTab] = deal([]);
for i=1:size(Lmemo,1)
    out = myTdmsReader.computeCd([Lmemo(i,:)' Cmemo(i,:)'],[],zeroV);
    DragTab(end+1,:)    = out.Drag';
    CDTab(end+1,:)      = out.Cd';
    WindTab(end+1,:)    = out.Uinf';
end

figure
for i=1:size(E,1) %scorro gli L/d
    subplot(2,1,1)
    plot(wind, (-E(i,:)+E0)./E0*100,'-p','DisplayN',"d/L = "+DsuL(i)), hold on
    
    subplot(2,1,2)
    CD0 = CDTab(1,:);
    plot(wind,CDTab(i+1,:),'-p','DisplayN',"C_{D_{d/L = "+DsuL(i)+"}}"), hold on
end
plot(wind,CDTab(1,:),'-pk','DisplayN',"C_{D.no platooning}");

subplot(2,1,1)
xlabel('Wind [n]'), ylabel('\DeltaE%')
legend

subplot(2,1,2)
xlabel('Wind [n]'), ylabel('C_D')
legend
set(gcf,'Color','w')

%%
figure
bigCol = 'k';
for i=1:size(CDTab,2)
    subplot(2,1,1)
    xticks(DsuL)
    dE(:,i) =  (-Lmemo(2:end,i)+E0(i))/E0(i)*100;
    ok=plot(DsuL,dE(:,i),'-o','DisplayN',"\DeltaE%_{n = "+wind(i)+"}");
    hold on
    
    thatCol = ok.Color;
    
    subplot(2,1,2)
    tipo = 'CDrel';
    xticks(DsuL)
    switch tipo
        case 'CDrel'
            dCD = (CDTab(2:end,i)-CDTab(1,i))/CDTab(1,i)*100;
            plot([DsuL(1)-0.1 nan DsuL],[0; nan; dCD],'-o','Color',bigCol,'MarkerFaceColor',thatCol,'DisplayN',"\Delta%C_{D_{n = "+wind(i)+"}}");
            ylabel('\DeltaC_D%'),
            ylim([-60 5])
            
            if i==1
                yPos= min(dCD,[],'all') +10;
                text(DsuL(1)-0.1,yPos,{'\downarrow\Delta%C_{D_{ref}}';' _{(no platooning)}'});
            end
            
        case 'CD'
            
            plot([DsuL(1)-0.1 nan DsuL],[CDTab(1,i); nan; CDTab(2:end,i)],'-O','Color',bigCol,'MarkerFaceColor',thatCol,'DisplayN',"C_{D_{n = "+wind(i)+"}}");
            ylabel('C_D'), ylim([0 0.6])
            if i==1
                yPos= min(CDTab(:,1:3),[],'all') -0.1;
                text(DsuL(1)-0.1,yPos,{'\uparrowC_{D_{ref}}';' _{(no platooning)}'});
            end
    end
    hold on
end
set(gcf,'Color','w')

subplot(2,1,1)
xlabel('L/D'), ylabel('\DeltaE%')
xlim([0 max(DsuL)+0.2])
legend

subplot(2,1,2)
xlabel('L/D'),
xlim([0 max(DsuL)+0.2])

legend
%%
T.cd = array2table(CDTab,'VariableNames',""+wind, 'RowNames',...
    ["ref", ""+DsuL]);
T.cd.Properties.DimensionNames = ["d/L" "n Elica"];
disp(T.cd)


